using System;
using Server.Network;
using System.Collections;
using Server.Spells;
using Server.Targeting;

namespace Server.Items
{
	public class MagicArrowTotem : BaseTotem
	{
      [Constructable]
		public MagicArrowTotem( int charges, Mobile owner ) : base( TotemType.MagicArrow, charges, owner )
		{
			Name = String.Format( "{0} totem [{1}]", ( Owner.HeadArmor is ShamansMask ) ? "fire ball" : "magic arrow", this.Owner.RawName.ToLower() );
		}
		
		public override void DoEffect( int count )
		{
//          this.PublicOverheadMessage( MessageType.Regular, 0x22, false, count.ToString() );
         
				ArrayList targets = new ArrayList();

				Map map = Owner.Map;

				if ( map != null )
				{
					IPooledEnumerable eable = map.GetMobilesInRange( this.Location, 5 );

					foreach ( Mobile m in eable )
					{
						if ( Owner != m && SpellHelper.ValidIndirectTarget( Owner, m ) && Owner.CanBeHarmful( m, false ) )
						{
							if ( !m.InLOS( this ) )
								continue;

							targets.Add( m );
						}
					}

					eable.Free();
				}

				if ( targets.Count > 0 )
				{
					Effects.PlaySound( this.Location, Owner.Map, ( Owner.HeadArmor is ShamansMask ) ? 0x15E : 0x1E5 );
               Effects.SendLocationParticles( EffectItem.Create( this.Location, this.Map, EffectItem.DefaultDuration ), 0x36BD, 8, 20, 5042 );

					for ( int i = 0; i < targets.Count; ++i )
					{
						Mobile m = (Mobile)targets[i];

// 						Owner.DoHarmful( m );
						SpellHelper.Damage( TimeSpan.FromSeconds(1.0), m, Owner, Utility.Dice( ( Owner.HeadArmor is ShamansMask ) ? 25 : 10, 10, 100 ), 0, 100, 0, 0, 0, 1 );
						
						if ( Owner.HeadArmor is ShamansMask )
                     Effects.SendMovingEffect( this, m, 0x36D4, 2, 0, false, false );
                  else
                     Effects.SendMovingEffect( this, m, 0x36E4, 2, 0, false, false );
					}
				}
         
      }

		public MagicArrowTotem( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}